<?php declare(strict_types=1);

namespace Newland\NeosFiltering\Validation;

use Neos\Error\Messages\Result;
use Neos\Utility\SchemaValidator;
use Symfony\Component\Yaml\Yaml;
use Neos\Flow\Annotations as Flow;
use function Safe\file_get_contents;

class SchemaFileValidator implements FilterConfigurationValidator
{
    protected const SCHEMA = 'resource://Newland.NeosFiltering/Private/Schema/DefaultFilterFactory.schema.yaml';

    /** @var array */
    protected static $parsedSchema;

    /**
     * @var SchemaValidator
     * @Flow\Inject()
     */
    protected $schemaValidator;

    public function validate(array $configuration, string $path): Result
    {
        if (!static::$parsedSchema) {
            static::$parsedSchema = Yaml::parse(file_get_contents(static::SCHEMA));
        }

        return $this->schemaValidator->validate($configuration, static::$parsedSchema);
    }
}
