<?php declare(strict_types=1);

namespace Newland\NeosFiltering\Tests\Unit\RangeSource;

use Neos\Flow\Tests\FunctionalTestCase;
use Newland\NeosFiltering\RangeSource\DirectRangeSource;

class DirectRangeSourceTest extends FunctionalTestCase
{

    public function testProvidesRangeSpecifiedByConstructor(): void
    {
        $source = new DirectRangeSource();
        $source->setArguments([ 'min' => 5, 'max' => 15 ]);
        $this->assertEquals(5, $source->min());
        $this->assertEquals(15, $source->max());
    }

}
