<?php declare(strict_types=1);

namespace Newland\NeosFiltering\Validation;

use Neos\Error\Messages\Error;
use Neos\Error\Messages\Result;

class DisallowNullChildrenValidator implements FilterConfigurationValidator
{
    public function validate(array $configuration, string $path): Result
    {
        $result = new Result();
        foreach ($configuration['children'] ?? [] as $name => $child) {
            if ($child === null) {
                $result->addError(new Error(sprintf(
                    '[%s.children.%s] Child cannot be null. '
                    . 'If you want to hide a filter item in the frontend please use `hideInFrontend: true` instead. '
                    . 'If you really want to disable the filter item including it\'s functionality '
                    . 'please use `disableCompletely: true`.',
                    $path,
                    $name
                )));
            } else {
                $childPath = sprintf('%s.children.%s', $path, $name);
                $result->merge($this->validate($child, $childPath));
            }
        }
        return $result;
    }
}
