<?php declare(strict_types=1);

namespace Newland\NeosFiltering\Items;

use Doctrine\ORM\Query\Expr;
use Doctrine\ORM\QueryBuilder;
use Newland\NeosFiltering\Contract\Expression;
use Newland\NeosFiltering\Contract\FilterItem;
use Newland\NeosFiltering\Contract\FilterItemCommon;
use Newland\NeosFiltering\Contract\HasQueryString;
use Newland\NeosFiltering\Contract\ModifiesDatabaseQueryDirectly;
use Newland\NeosFiltering\Contract\NeedsDatabaseColumn;
use Newland\NeosFiltering\Contract\QueryBoundFilterItem;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;

/**
 * Renders a hidden input field used to carry pagination information.
 */
class PaginationInput implements FilterItem, QueryBoundFilterItem, ModifiesDatabaseQueryDirectly
{
    use FilterItemCommon, HasQueryString;

    public function modifyDatabaseQuery(QueryBuilder $query): QueryBuilder
    {
        $pageSize = $this->configuration['pageSize'] ?? 10;
        $page = max((int) $this->state, 1);
        $offset = ($page - 1) * $pageSize;

        return $query
            ->setFirstResult($offset)
            ->setMaxResults($pageSize);
    }

    public function render(RenderingContextInterface $renderingContext)
    {
        return $this->initializeView()->render('PaginationInput');
    }

    public function queryExpression(Expr $expr): Expression
    {
        return Expression::empty();
    }
}
