<?php declare(strict_types=1);
namespace Newland\NeosFiltering\Contract;

/*
 * This file is part of the "neos-filtering" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

/**
 * Trait encapsulating common logic where the affected database column is passed
 * into the filter item from the outside.
 */
trait NeedsDatabaseColumn
{
    /** @var string */
    protected $databaseColumn;

    public function setDatabaseColumn(string $databaseColumn): void
    {
        $this->databaseColumn = $databaseColumn;
    }

    public function getDatabaseColumn(): ?string
    {
        return $this->databaseColumn;
    }

    protected function throwIfNoDatabaseColumnDeclared(): void
    {
        if ($this->databaseColumn === null) {
            // TODO Throw more specific exception.
            throw new \Exception(
                'No databaseColumn specified'
            );
        }
    }
}
