<?php declare(strict_types=1);
namespace Newland\NeosFiltering\Contract;

/*
 * This file is part of the "neos-filtering" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

/**
 * Default implementation for the `QueryBoundFilterItem` interface.
 * Note: This interface only provides a common implementation - you must explicitly implement
 *       the `QueryBoundFilterItem` interface if you want to mark your filter item as having a query string.
 *
 * @see QueryBoundFilterItem
 */
trait HasQueryString
{
    /** @var string */
    protected $queryString;

    public function getQueryString(): ?string
    {
        return $this->queryString;
    }

    public function setQueryString(string $queryString): void
    {
        $this->viewAssignments['queryString'] = $queryString;
        $this->queryString = $queryString;
    }

    protected function throwIfNoQueryString(): void
    {
        if ($this->queryString === null) {
            throw new \Exception('Please specify a query string');
        }
    }

    public function getQueryForOverrides(array $overrides): array
    {
        $query = [];
        if ($this instanceof DataSourcedFilterItem) {
            $data = $this->getDataFromDataSource();
            $dataValues = array_column($data, 'value');
            foreach ($overrides as $property => $overrideValues) {
                if (($this->configuration['override']['property'] ?? null) === $property) {
                    foreach ($overrideValues as $key => $overrideValue) {
                        if (in_array($overrideValue, $dataValues, true)) {
                            $queryString = $this->getQueryString();
                            $query[$queryString] = (array) ($query[$queryString] ?? []);
                            $query[$queryString][] = $overrideValue;
                        }
                    }
                }
            }
        }

        return $query;
    }
}
