<?php declare(strict_types=1);
namespace Newland\NeosFiltering\Contract;

/*
 * This file is part of the "neos-filtering" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Neos\Service\DataSource\DataSourceInterface;

/**
 * Marks a filter item as having a data source providing options that are being displayed.
 *
 * @see HasDataSource for a default implementation
 */
interface DataSourcedFilterItem
{
    public function setDataSource(DataSourceInterface $dataSource): void;

    public function getDataSource(): ?DataSourceInterface;

    public function setDataSourceArguments(array $arguments): void;

    public function getDataSourceArguments(): array;
}
