function charactersOfWhitespaceOnFirstLine (lines) {
    for (const line of lines) {
        if (line.trim().length === 0) {
            continue;
        }

        const match = /^\s+/.exec(line);
        if (!match) {
            continue;
        }

        return match[0].length;
    }

    return 0;
}

export function stripMultilineIndention (input) {
    try {
        const lines = input.split('\n');
        const whitespace = charactersOfWhitespaceOnFirstLine(lines);
        if (whitespace === 0) {
            return input;
        }

        const regex = new RegExp(`^\\s{0,${whitespace}}`);
        return lines.map(line => line.replace(regex, '')).join('\n');
    } catch (e) {
        return input;
    }
}
