<?php
namespace Newland\NeosCommon\Service;

use Neos\ContentRepository\Domain\Model\Node;
use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Mvc\ActionRequest;
use Neos\Flow\Mvc\Controller\ControllerContext;
use Neos\Neos\Domain\Model\Site;
use Neos\Neos\Domain\Service\ContentContext;

class ContextService
{

    public function siteNodeFromControllerContext(ControllerContext $controllerContext): ?Node
    {
        $request = $controllerContext->getRequest();
        if (!($request instanceof ActionRequest)) {
            return null;
        }

        /** @var mixed $node */
        $node = $request->getInternalArgument('__node');

        if (!($node instanceof Node)) {
            return null;
        }
        return $this->siteNodeFromReferenceNode($node);
    }

    public function siteNodeFromReferenceNode(NodeInterface $node): ?Node
    {
        $context = $node->getContext();
        if (!($context instanceof ContentContext)) {
            return null;
        }

        $siteNode = $context->getCurrentSiteNode();
        return ($siteNode instanceof Node) ? $siteNode : null;
    }

    public function siteFromReferenceNode(NodeInterface $node): ?Site
    {
        $context = $node->getContext();
        if (!($context instanceof ContentContext)) {
            return null;
        }

        return $context->getCurrentSite();
    }
}
