<?php
namespace Newland\NeosCommon\LinkHandler;

use Neos\Flow\Annotations as Flow;
use Neos\Flow\Configuration\Exception\InvalidConfigurationException;
use Neos\Flow\ObjectManagement\ObjectManager;
use Newland\NeosCommon\LinkHandler\Handler\AbstractLinkHandler;
use Newland\NeosCommon\LinkHandler\Handler\ModelWithDetailPluginHandler;

/**
 * @Flow\Scope("singleton")
 */
class LinkHandlerFactory
{

    /**
     * @var array
     * @Flow\InjectConfiguration(path="linkhandler")
     */
    protected $configuration = [];

    /**
     * @var ObjectManager
     * @Flow\Inject()
     */
    protected $objectManager;

    public function get(string $nodeType, string $language = null): AbstractLinkHandler
    {
        $config = $this->configuration['recordTypes'][$nodeType] ?? null;
        if ($config === null) {
            throw new InvalidConfigurationException(sprintf(
                'Configuration for %1$s not found in Newland.NeosCommon.linkhandler.recordTypes.%1$s',
                $nodeType
            ));
        }

        $className = ModelWithDetailPluginHandler::class;
        if (array_key_exists('handler', $config)) {
            $className = $config['handler'];
        }

        if (!class_exists($className)) {
            throw new InvalidConfigurationException(
                'Configured generator ' . $className . ' for node type ' . $nodeType . ' does not exist'
            );
        }

        $instance = $this->objectManager->get($className);
        if (!($instance instanceof AbstractLinkHandler)) {
            throw new InvalidConfigurationException(
                'Configured generator ' . get_class($instance) . ' for node type ' . $nodeType
                . ' must implement ' . AbstractLinkHandler::class
            );
        }

        $instance->setConfiguration($config);
        $instance->setRecordType($nodeType);
        $instance->setLanguage($language);
        return $instance;
    }

    public function allTypes()
    {
        return array_keys($this->configuration['recordTypes']);
    }
}
