<?php
namespace Newland\NeosCommon\Eel\Helper;

/*
 * This file is part of the "neos-common" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\Node;
use Neos\Flow\Mvc\ActionRequest;

/**
 * Meta description EEL helper.
 *
 * Prepares a meta description for the current context.
 */
class MetaDescriptionHelper extends ObjectPropertyHelper
{
    /**
     * Override the meta description of the current page
     *
     * @param Node $node
     * @param ActionRequest $request
     * @param string|null $defaultValue
     * @return string
     */
    public function getDescription(Node $node, ActionRequest $request, ?string $defaultValue = ''): string
    {
        $this->node = $node;
        $this->request = $request;
        $this->value = (string) $defaultValue;

        $this->getConfiguration();

        if ($this->override) {
            $this->setValueFromRequestedRecord();
        }

        return $this->metaData->getDescriptionTrimmed() ?: (string) $defaultValue;
    }
}
