<?php declare(strict_types=1);

namespace Newland\NeosCommon\ViewHelpers;

use Neos\Flow\Mvc\ActionResponse;
use Neos\FluidAdaptor\Core\Widget\AbstractWidgetViewHelper as NeosAbstractWidgetViewHelper;

/**
 * Small wrapper around the widget view helper in order to preserve Neos 4.x & 5.x compatibility.
 * This class aims to have the same interface as the Neos 5.x version, converting Neos 4.x responses
 * into the new format.
 */
class AbstractWidgetViewHelper extends NeosAbstractWidgetViewHelper
{
    protected function initiateSubRequest(): string
    {
        /** @var string|ActionResponse $result */
        $result = parent::initiateSubRequest();

        if ($result instanceof ActionResponse) {
            return $result->getContent();
        }

        return (string) $result;
    }

    public function render(): string
    {
        return $this->initiateSubRequest();
    }
}
