<?php
namespace Newland\NeosCommon\ViewHelpers;

/*
 * This file is part of the "neos-common" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Neos\Flow\Mvc\ActionRequest;
use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use Neos\ContentRepository\Domain\Model\Node;
use Newland\NeosCommon\Eel\Helper\NodeUtilityHelper;

class IsDetailPageViewHelper extends AbstractViewHelper
{
    /**
     * @var NodeUtilityHelper
     * @Flow\Inject
     */
    protected $nodeUtility;

    /**
     * @param Node $node
     * @return bool
     */
    public function render(Node $node): bool
    {
        return $this->nodeUtility->isDetailPage($node, $this->controllerContext->getRequest());
    }
}
