<?php declare(strict_types=1);

namespace Newland\NeosCommon\Logging;

use Neos\Flow\Annotations as Flow;
use Neos\Flow\Log\PsrLoggerFactoryInterface;
use Psr\Log\LoggerInterface;

/**
 * @Flow\Scope("singleton")
 */
class DeprecationLog
{
    /**
     * @var LoggerInterface
     */
    protected $logger;

    public function logDeprecation(string $message): void
    {
        $this->logger->info($message);
    }

    public function injectLogger(PsrLoggerFactoryInterface $loggerFactory): void
    {
        $this->logger = $loggerFactory->get('newlandNeosCommonDeprecationLog');
    }
}
