<?php
namespace Newland\NeosCommon\Translation;

/*
 * This file is part of the "neos-common" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\NodeInterface;

trait LanguageAwareDataSource
{
    protected function getLanguage(?NodeInterface $node): ?string
    {
        if ($node === null) {
            return null;
        }

        $dimensions = $node->getDimensions();

        return $dimensions['language'][0] ?? null;
    }
}
