<?php declare(strict_types=1);

namespace Unit\Utility;

use Neos\Flow\Tests\BaseTestCase;
use Newland\NeosCommon\Utility\PaginationUtility;

class PaginationUtilityTest extends BaseTestCase
{
    /** @var PaginationUtility */
    protected $subject;

    public function setUp()
    {
        $this->subject = new PaginationUtility();
    }

    /**
     * @dataProvider getPaginationExamples
     */
    public function testPaginationData(int $count, int $page, int $itemsPerPage, array $paginationData): void
    {
        self::assertSame($paginationData, $this->subject->getPaginationData($count, $page, $itemsPerPage));
    }

    public function getPaginationExamples(): array
    {
        return [
            [
                1,
                1,
                12,
                [
                    'isFirst' => true,
                    'page' => 1,
                    'currentPageFrom' => 1,
                    'currentPageTo' => 1,
                    'isLast' => true,
                    'count' => [
                        'items' => 1,
                        'pages' => 1,
                    ],
                ],
            ],
            [
                12,
                1,
                12,
                [
                    'isFirst' => true,
                    'page' => 1,
                    'currentPageFrom' => 1,
                    'currentPageTo' => 12,
                    'isLast' => true,
                    'count' => [
                        'items' => 12,
                        'pages' => 1,
                    ],
                ],
            ],
            [
                13,
                1,
                12,
                [
                    'isFirst' => true,
                    'page' => 1,
                    'currentPageFrom' => 1,
                    'currentPageTo' => 12,
                    'isLast' => false,
                    'count' => [
                        'items' => 13,
                        'pages' => 2,
                    ],
                ],
            ],
            [
                13,
                2,
                12,
                [
                    'isFirst' => false,
                    'page' => 2,
                    'currentPageFrom' => 13,
                    'currentPageTo' => 13,
                    'isLast' => true,
                    'count' => [
                        'items' => 13,
                        'pages' => 2,
                    ],
                ],
            ],
            [
                25,
                2,
                12,
                [
                    'isFirst' => false,
                    'page' => 2,
                    'currentPageFrom' => 13,
                    'currentPageTo' => 24,
                    'isLast' => false,
                    'count' => [
                        'items' => 25,
                        'pages' => 3,
                    ],
                ],
            ],
        ];
    }
}
