<?php
namespace Neos\Flow\Persistence\Doctrine\Migrations;

use Doctrine\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

/**
 * Auto-generated Migration: Please modify to your needs! This block will be used as the migration description if getDescription() is not used.
 */
class Version20190614011743 extends AbstractMigration
{

    /**
     * @return string
     */
    public function getDescription()
    {
        return '';
    }

    /**
     * @param Schema $schema
     * @return void
     */
    public function up(Schema $schema)
    {
        $types = [ 'tour', 'gastronomy', 'poi', 'lodging', 'lodgings', 'directMarketer' ];
        foreach ($types as $type)  {
            $sql = sprintf(
                'UPDATE neos_contentrepository_domain_model_nodedata 
                SET properties=REPLACE(properties, "record:%1$s:", "record:article:")
                WHERE properties LIKE "%%record:%1$s:%%"',
                $type
            );
            $this->addSql($sql);
        }
    }

    /**
     * @param Schema $schema
     * @return void
     */
    public function down(Schema $schema)
    {
        // Not reversable.
    }
}