<?php

namespace Newland\NeosCommon\Utility;

use Neos\Flow\Annotations as Flow;

/**
 * @Flow\Scope("singleton")
 */
class UrlUtility
{
    /**
     * @Flow\InjectConfiguration
     * @var array
     */
    protected $configuration;

    public function appendTrackingParameters(string $uri, ?array $requestParameters): string
    {
        if (!$this->configuration['appendTrackingParameters']) {
            return $uri;
        }

        if ($requestParameters === null) {
            return $uri;
        }

        $allowedKeys = [ '_gl', '_up', '_ga' ];
        $allowedKeyPrefixes = [ '_ga_' ];

        $trackingParameters = array_filter(
            $requestParameters,
            static function ($value, $key) use ($allowedKeys, $allowedKeyPrefixes) {
                return in_array($key, $allowedKeys, true) || in_array(substr($key, 0, 4), $allowedKeyPrefixes, true);
            },
            ARRAY_FILTER_USE_BOTH
        );

        if (str_contains($uri, '?')) {
            return $uri . '&' . http_build_query($trackingParameters);
        }

        return $uri . '?' . http_build_query($trackingParameters);
    }
}
