<?php declare(strict_types=1);
namespace Newland\NeosCommon\Utility;

use Neos\Flow\Core\Booting\Exception\SubProcessException;

class Scripts extends \Neos\Flow\Core\Booting\Scripts
{

    public static function executeInteractiveCommand(
        string $commandIdentifier,
        array $settings,
        array $commandArguments
    ): void {
        $command = self::buildSubprocessCommand($commandIdentifier, $settings, $commandArguments);
        passthru($command, $return);
        if ($return !== 0) {
            throw new SubProcessException('Command ' . $commandIdentifier . ' failed.', 1355480641);
        }
    }
}
