<?php
namespace Newland\NeosCommon\ViewHelpers;

/*
 * This file is part of the "neos-common" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Annotations as Flow;
use Neos\FluidAdaptor\Core\Widget\AbstractWidgetViewHelper;
use Newland\NeosCommon\ViewHelpers\Controller\PaginationController;

class PaginationViewHelper extends AbstractWidgetViewHelper
{
    /**
     * @var PaginationController
     * @Flow\Inject()
     */
    protected $controller;

    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('currentPage', 'integer', 'Number of the currently active page', true);
        $this->registerArgument('totalPageCount', 'integer', 'Total number of pages', true);
    }

    public function render(): string
    {
        $response = $this->initiateSubRequest();
        return (string) $response->getBody();
    }
}
