<?php
namespace Newland\NeosCommon\Service;

/*
 * This file is part of the "neos-common" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Neos\Flow\Mvc\Routing\ObjectPathMapping;
use Neos\Flow\Mvc\Routing\ObjectPathMappingRepository;
use Neos\Flow\Persistence\PersistenceManagerInterface;

class ObjectPathMappingService
{
    /**
     * @var ObjectPathMappingRepository
     * @Flow\Inject()
     */
    protected $objectPathMappingRepository;

    /**
     * @var PersistenceManagerInterface
     * @Flow\Inject()
     */
    protected $persistenceManager;

    /**
     * Flush all records from the object path mapping table for a certain object type.
     *
     * @param string $objectType
     */
    public function flushMappings(string $objectType, array $ids = null): void
    {
        $objectType = trim($objectType, '\\');

        if ($ids !== null) {
            $query = $this->objectPathMappingRepository->createQuery();
            $query->matching(
                $query->logicalAnd([
                    $query->equals('objectType', $objectType),
                    $query->in('identifier', $ids)
                ])
            );
            $records = $query->execute();
        } else {
            $records = $this->objectPathMappingRepository->findByObjectType($objectType);
        }

        foreach ($records as $record) {
            /** @var ObjectPathMapping $record */
            $this->objectPathMappingRepository->remove($record);
        }

        $this->persistenceManager->persistAll();
    }
}
