<?php

/*
 * This file is part of the "neos-common" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

namespace Newland\NeosCommon\Eel\Helper;

use Neos\Flow\Annotations as Flow;
use Neos\Eel\ProtectedContextAwareInterface;
use Neos\Neos\Domain\Model\Site;
use Newland\NeosCommon\Service\ConfigurationService;

class ConfigurationHelper implements ProtectedContextAwareInterface
{
    /**
     * @var ConfigurationService
     * @Flow\Inject
     */
    protected $configurationService;

    /**
     * @param string $methodName
     * @return boolean
     */
    public function allowsCallOfMethod($methodName): bool
    {
        return true;
    }

    public function getSiteConfiguration(Site $site, string $prefix = '', string $suffix = '')
    {
        return $this->configurationService->getSiteConfiguration($prefix, $suffix, $site);
    }
}
