# Neos common.

This package supplies frequently used project features for Neos CMS.

Installation
------------

If you want to use any of the features in your site package, make sure to add it as a dependency to
the `composer.json` file of the site package. Otherwise the packages might have the wrong loading order.


Meta tags
---------

Overriding meta tags relies heavily on Neos core packages (`neos/neos` and `neos/neos-seo`).
The Fusion objects for the following tags / sections are drop-in replacements for the 
standard core objects:

* title tag
* description tag
* OpneGraph tags
* breadcrumbs

To use any of these, just replace the Fusion object reference.
For example replace this...

```
page {
    head {
        titleTag = Neos.Seo:TitleTag
        metaDescriptionTag = Neos.Seo:MetaDescriptionTag
        openGraphMetaTags = Neos.Seo:OpenGraphMetaTags
    }
}
```

... with this:

```
page {
    head {
        titleTag = Newland.NeosCommon:TitleTag
        metaDescriptionTag = Newland.NeosCommon:MetaDescription
        openGraphMetaTags = Newland.NeosCommon:OpenGraphMetaTags
    }
}
```

Breadcrumbs
-----------

To use record-aware breadcrumbs (e.g. display the record title on a detail page), override the
Fusion object and set a custom template path.

```
page {
    body {
        parts {
            breadcrumbNavigation = Newland.NeosCommon:BreadcrumbMenu {
                templatePath = 'resource://Vendor.MyTheme/Private/Templates/FusionObjects/BreadcrumbNavigation.html'
            }
        }
    }
}
```

Inside the template you can then use extended view helper logic (`isDetailPage` and `nodeTitle`) where needed:

### Template Example:

```
{namespace common=Newland\NeosCommon\ViewHelpers}

<f:if condition="{common:isDetailPage(node: node)}">
    <span>{detailTitle}</span>
</f:if>
```

### Linkhandler

The Linkhandler component allows editors to link to records. For this functionality
to work in the expected way the following setup steps have to be followed:

1. Setup routes in `$PROJECT_ROOT/Configuration/Routes.yaml`:
    ```yaml
    - name: 'Common'
      uriPattern: '<CommonSubroutes>'
      subRoutes:
        'CommonSubroutes':
          package: 'Newland.NeosCommon'
    ```

2. Configure records that can be linked to. In order for records to be found
   correctly they must be configured in the site package preferences. For an
   example configuration check out ![Settings.yaml](./Configuration/Settings.yaml)

3. Make sure you are using the `Neos.Neos:ConvertUris` processor on the Nodes
   that receive links in rich text fields.
