<?php
namespace Newland\NeosCommon\Sitemap;

class SitemapUrl
{

    /**
     * @var string
     */
    protected $location;

    /**
     * @var \DateTime
     */
    protected $lastModified;

    /**
     * @var array
     */
    protected $additionalTags;

    public function __construct(string $location, \DateTime $lastModified = null, array $additionalTags = [])
    {
        $this->location = $location;
        $this->lastModified = $lastModified;
        $this->additionalTags = $additionalTags;
    }

    public function toXml(): string
    {
        $tags = array_merge(
            [ 'loc' => $this->location, 'lastmod' => $this->lastModified ],
            $this->additionalTags
        );
        return '<url>' . $this->arrayToXml($tags) . '</url>';
    }

    private function arrayToXml(array $array): string
    {
        $xml = '';
        foreach ($array as $key => $value) {
            if (!$value) {
                continue;
            }
            if ($value instanceof \DateTime) {
                $value = $value->format(\DateTime::ATOM);
            }
            $xml .= '<' . $key . '>' . htmlspecialchars($value) . '</' . $key . '>';
        }
        return $xml;
    }
}
