<?php
namespace Newland\NeosCommon\Service;

/*
 * This file is part of the "neos-common" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

/**
 * Interface for the record search service for finding records based on a fulltext search
 */
interface RecordSearchServiceInterface
{
    /**
     * @param array $recordIdentifiers
     * @return array|null
     */
    public function findByIdentifiers(array $recordIdentifiers);

    /**
     * @param string $searchTerm
     * @param array $recordTypes
     * @return array|null
     */
    public function findBySearchFields(string $searchTerm, array $recordTypes);
}
