<?php
namespace Newland\NeosCommon\Service;

/*
 * This file is part of the "neos-common" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Doctrine\ORM\EntityManagerInterface;
use Neos\ContentRepository\Domain\Model\Node;
use Neos\ContentRepository\Domain\Model\NodeData;

/**
 * @Flow\Scope("singleton")
 */
class NodeService
{
    /**
     * @Flow\Inject
     * @var EntityManagerInterface
     */
    protected $entityManager;

    /**
     * @param Node[] $nodes
     * @return Node|null
     */
    public function getFirstAvailableNode($nodes)
    {
        $firstAvailableNode = null;

        $orphanedNodes = $this->getOrphanedNodes();

        $orphanedNodesIdentifiers = array_map(function (array $node) {
            return $node['identifier'];
        }, $orphanedNodes);

        foreach ($nodes as $node) {
            if (!in_array($node->getIdentifier(), $orphanedNodesIdentifiers)) {
                $firstAvailableNode = $node;
                break;
            }
        }

        return $firstAvailableNode;
    }

    private function getOrphanedNodes(): array
    {
        /** @var \Doctrine\ORM\QueryBuilder $queryBuilder */
        $queryBuilder = $this->entityManager->createQueryBuilder();

        $workspaceName = 'live';
        $workspaceList = [ $workspaceName ];

        $query = $queryBuilder
            ->select('n')
            ->from(NodeData::class, 'n')
            ->leftJoin(
                NodeData::class,
                'n2',
                \Doctrine\ORM\Query\Expr\Join::WITH,
                'n.parentPathHash = n2.pathHash AND n2.workspace IN (:workspaceList)'
            )
            ->where('n2.path IS NULL')
            ->andWhere($queryBuilder->expr()->not('n.path = :slash'))
            ->andWhere('n.workspace = :workspace');
        $parameters = [
            'workspaceList' => $workspaceList,
            'slash' => '/',
            'workspace' => $workspaceName,
        ];

        $orphanedNodes = $query
            ->setParameters($parameters)
            ->getQuery()->getArrayResult();

        return $orphanedNodes;
    }
}
