<?php declare(strict_types=1);

namespace Newland\NeosCommon\Tests\Unit\LinkHandler\Mock;

use Newland\NeosCommon\LinkHandler\Handler\AbstractLinkHandler;
use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Mvc\Controller\ControllerContext;
use Newland\NeosCommon\LinkHandler\Domain\Model\Record;

class LinkHandlerMock extends AbstractLinkHandler
{
     public function generateRecordLink(
        Record $record,
        ControllerContext $controllerContext,
        NodeInterface $contextNode,
        bool $absolute
    ): ?string {
         return $this->configuration['linkToGenerate'];
    }


    /**
     * @param string $recordIdentifier
     * @return Record|null
     */
    public function findByIdentifier(string $recordIdentifier): ?Record
    {
        return $this->configuration['recordToFind'];
    }

    /**
     * @param string $searchTerm
     * @return Record[]
     */
    public function findBySearchTerm(string $searchTerm): array
    {
        return $this->configuration['recordsToFind'];
    }

    public function getConfiguration(): array
    {
        return $this->configuration;
    }

    public function getRecordType(): string
    {
        return $this->recordType;
    }

    public function getLanguage(): ?string
    {
        return $this->language;
    }
}