<?php
namespace Newland\NeosCommon\ViewHelpers;

/*
 * This file is part of the "neos-common" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Annotations as Flow;
use Neos\FluidAdaptor\Core\Widget\AbstractWidgetViewHelper;
use Newland\NeosCommon\ViewHelpers\Controller\GalleryController;

class GalleryViewHelper extends AbstractWidgetViewHelper
{
    /**
     * @var GalleryController
     * @Flow\Inject()
     */
    protected $controller;

    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('image', 'object', 'Single image to render in the gallery', false);
        $this->registerArgument('images', 'array', 'Images to render in the gallery', false);
        $this->registerArgument('videos', 'array', 'Videos to render in the gallery', false);
        $this->registerArgument('panoramaUri', 'string', 'Link to external panorama image', false);
        $this->registerArgument('flight3dUri', 'string', 'Link to external 3D flight', false);
        $this->registerArgument('wrapperClass', 'string', 'Class to apply to wrapper div', false);
    }

    public function render(): string
    {
        $response = $this->initiateSubRequest();
        return (string) $response->getBody();
    }
}
