<?php
namespace Newland\NeosCommon\ViewHelpers\Controller;

/*
 * This file is part of the "neos-common" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */


use Neos\FluidAdaptor\Core\Widget\AbstractWidgetController;

class GalleryController extends AbstractWidgetController
{

    /** @var object */
    protected $image = null;

    /** @var array */
    protected $images = [];

    /** @var array */
    protected $videos = [];

    /** @var string */
    protected $panoramaUri = null;

    /** @var string */
    protected $flight3dUri = null;

    /** @var string */
    protected $wrapperClass = '';

    public function initializeAction(): void
    {
        $this->images = (array) $this->widgetConfiguration['images'] ?? [];
        $this->videos = (array) $this->widgetConfiguration['videos'] ?? [];
        $this->image = $this->widgetConfiguration['image'] ?? null;
        $this->panoramaUri = $this->widgetConfiguration['panoramaUri'] ?? null;
        $this->flight3dUri = $this->widgetConfiguration['flight3dUri'] ?? null;
        $this->wrapperClass = $this->widgetConfiguration['wrapperClass'] ?? '';
    }

    public function indexAction(): void
    {
        $items = $this->image !== null ? [ $this->image ] : $this->images;

        // Videos are added so the third element in the gallery is a video, if one is available
        if ($this->videos) {
            array_splice($items, 1, 0, $this->videos);
        }

        $this->view->assignMultiple([
            'items' => $items,
            'showGallery' => count($items) > 0,
            'panoramaUri' => $this->panoramaUri,
            'flight3dUri' => $this->flight3dUri,
            'wrapperClass' => $this->wrapperClass,
            'containerItemsOffset' => count($items) > 2 ? 3 : 1,
        ]);
    }
}
