<?php
namespace Newland\NeosCommon\Models;

/*
 * This file is part of the "neos-common" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

class MetaData
{
    protected $title = '';
    protected $description = '';
    protected $url = '';
    protected $image = '';
    protected $type = 'article';

    public function getTitle(): string
    {
        return $this->title;
    }

    public function setTitle(string $title)
    {
        $this->title = $title;
    }

    public function getDescription(): string
    {
        return strip_tags((string) $this->description);
    }

    public function setDescription(string $description)
    {
        $this->description = $description;
    }

    public function getDescriptionTrimmed(): string
    {
        $description = $this->getDescription();

        if (strlen($description) > 150) {
            $description = substr($description, 0, 147) . '...';
        }

        return $description;
    }

    public function getUrl(): string
    {
        return $this->url;
    }

    public function setUrl(string $url)
    {
        $this->url = $url;
    }

    public function getImage(): string
    {
        return $this->image;
    }

    public function setImage(string $image)
    {
        $this->image = $image;
    }

    public function getType(): string
    {
        return $this->type;
    }

    public function setType(string $type)
    {
        $this->type = $type;
    }
}
