<?php
namespace Newland\NeosCommon\LinkHandler\Handler;

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Mvc\Controller\ControllerContext;
use Newland\NeosCommon\LinkHandler\Domain\Model\Record;

abstract class AbstractLinkHandler
{

    /** @var array */
    protected $configuration;

    /** @var string */
    protected $recordType;

    /** @var string|null */
    protected $language;

    public function setConfiguration(array $configuration): void
    {
        $this->configuration = $configuration;
    }

    public function setRecordType(string $recordType): void
    {
        $this->recordType = $recordType;
    }

    public function setLanguage(string $language = null): void
    {
        $this->language = $language;
    }

    /**
     * Generates a record link for the given record.
     *
     * @param Record $record
     * @param ControllerContext $controllerContext
     * @param NodeInterface $contextNode
     * @param bool $absolute
     * @return string|null
     */
    abstract public function generateRecordLink(
        Record $record,
        ControllerContext $controllerContext,
        NodeInterface $contextNode,
        bool $absolute
    ): ?string;

    /**
     * @param string $recordIdentifier
     * @return Record|null
     */
    abstract public function findByIdentifier(string $recordIdentifier): ?Record;

    /**
     * @param string $searchTerm
     * @return Record[]
     */
    abstract public function findBySearchTerm(string $searchTerm): array;
}
