<?php
namespace Newland\NeosCommon\Command;

/*
 * This file is part of the "neos-common" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Neos\Flow\Cli\CommandController;
use Newland\NeosCommon\Service\ObjectPathMappingService;

class RoutingCommandController extends CommandController
{
    /**
     * @var ObjectPathMappingService
     * @Flow\Inject()
     */
    protected $objectPathMappingsService;

    /**
     * Flush all records from the object path mapping table for a certain object type.
     *
     * @param string $objectType The FQNS of the object type. Leading backslashes are ignored.
     */
    public function flushMappingsCommand(string $objectType)
    {
        $this->objectPathMappingsService->flushMappings($objectType);
    }
}
