<?php
namespace Newland\NeosCommon\ViewHelpers\Controller;

/*
 * This file is part of the "neos-common" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */


use Neos\FluidAdaptor\Core\Widget\AbstractWidgetController;
use Newland\NeosCommon\Exceptions\UnknownVideoException;
use Newland\NeosCommon\Video\VimeoVideo;
use Newland\NeosCommon\Video\YoutubeVideo;

class GalleryController extends AbstractWidgetController
{

    /** @var object */
    protected $image = null;

    /** @var array */
    protected $images = [];

    /** @var string */
    protected $videoUri = null;

    /** @var string */
    protected $panoramaUri = null;

    /** @var string */
    protected $flight3dUri = null;

    /** @var string */
    protected $wrapperClass = '';

    public function initializeAction(): void
    {
        $this->images = (array) $this->widgetConfiguration['images'] ?? [];
        $this->image = $this->widgetConfiguration['image'] ?? null;
        $this->videoUri = $this->widgetConfiguration['videoUri'] ?? null;
        $this->panoramaUri = $this->widgetConfiguration['panoramaUri'] ?? null;
        $this->flight3dUri = $this->widgetConfiguration['flight3dUri'] ?? null;
        $this->wrapperClass = $this->widgetConfiguration['wrapperClass'] ?? '';
    }

    public function getVideoImageAndUrl($url)
    {
        if (!$url) {
            return null;
        }

        if (strpos($url, 'youtu') !== false) {
            return new YoutubeVideo($url);
        }

        if (strpos($url, 'vimeo') !== false) {
            return new VimeoVideo($url);
        }

        throw new UnknownVideoException('The video url ' . $url . ' cannot be resolved');
    }

    public function indexAction(): void
    {
        $items = $this->image !== null ? [ $this->image ] : $this->images;

        if ($this->videoUri) {
            $video = $this->getVideoImageAndUrl($this->videoUri);

            $videoItemArray = [[
                'title' => '',
                'video' => $video->getEmbedUrl(),
                'uri' => $video->getPreviewUrl(),
            ]];

            array_splice($items, 1, 0, $videoItemArray);
        }

        $this->view->assignMultiple([
            'items' => $items,
            'showGallery' => count($items) > 0,
            'panoramaUri' => $this->panoramaUri,
            'flight3dUri' => $this->flight3dUri,
            'wrapperClass' => $this->wrapperClass,
            'containerItemsOffset' => count($items) > 2 ? 3 : 1,
        ]);
    }
}
