<?php declare(strict_types=1);

namespace Newland\NeosCommon\ConfigurationValidation;

use Neos\Error\Messages\Result;
use Neos\Flow\Annotations as Flow;
use Neos\Flow\Aop\JoinPointInterface;

/**
 * @Flow\Aspect()
 */
class ConfigurationValidationAspect
{

    /**
     * @var ConfigurationValidationHelper
     * @Flow\Inject()
     */
    protected $helper;

    /**
     * @Flow\Around("method(Neos\Flow\Configuration\ConfigurationSchemaValidator->validate())")
     * @param JoinPointInterface $joinPoint
     * @return Result
     */
    public function validate(JoinPointInterface $joinPoint): Result
    {
        /** @var Result $result */
        $result = $joinPoint->getAdviceChain()->proceed($joinPoint);
        $result->merge($this->helper->getAdditionalValidationResults());
        return $result;
    }
}
