# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [1.14.0] - 2019-09-17
### Added
- Meta tag fallback properties can be configured, see `Configuration/Settings` for an example
  and more info.
  
### Changed
- Meta tags were extracted from this package to `neos-meta-tags`. See "action required" below.

### Action Required
- `IsDetailPageViewHelper` and `NodeTitleViewHelper` have moved from this package to
  `neos-meta-tags`. If in use, you need to change the namespace for both in every template.
- Configuration for scenarios (when displaying meta tags for records) has moved to `neos-meta-tags`.
  If you have overriden those, then you must adjust the configuration path.
- The fallback logic for which fields are used as values for meta tags has partly moved from
  Fusion to Yaml.
  Please override the configuration in your project if needed, e.g.:
```
Newland:
  NeosMetaTags:
    fallback:
      twitter:
        description:
          # set your new field as first value
          - myCustomDescriptionField
          # include the default fallback fields (if they still make sense)
          - twitterCardDescription
          - openGraphDescription
          - metaDescription
```  
- Eel helpers for meta tags have moved to `neos-meta-tags`. Please replace them in your page fusion.

## [1.12.0] - 2019-07-12
### Added
- LinkHandlers are now language aware.
- LinkHandler records can now be shortcut targets

### Changed
- Meta tag override is now enabled by default and has to be explicitly disabled if not needed.
  To disable it you can set `Newland.NeosCommon.meta.override` to `false`.

## [1.10.5] - 2019-06-25
### Added
- Configuration validation (e.g. via `php flow configuration:validate` now contains errors for 
  UUID usage in `isDescendantOf` policy matchers).

## [1.10.2] - 2019-06-19
### Changed
- The `Neos_Fusion_Content` cache which is used by Neos to cache the page content is now using
  a sqlite backend instead of the default file backend. This improves performance on pages with
  lots of nodes considerably.

## [1.10.0]
### Added
- Added `flow domain:migrate` command to replace domain hostnames by pattern.

### Fixed
- Fixed typing issues with `Configuration` eel helper

## [1.5.1] - 2019-05-09
### Added
- New method on NodeRepository `findOneByNodeType`

## [1.5.0] - 2019-05-07
### Added
- Add NodeRepository to NeosCommon
- New `node:repairall` command that repairs nodes of all workspaces.

### Changed
- PHP 7.2 and up is now required.

## [1.4.1] - 2019-04-17
### Added
- NodeService can tell the current site from a node
- New `Newland.NeosCommon.Configuration` eel helper has been added to fetch configuration values in fusion

### Fixed
- Exceptions in linkhandler implementations now don't render the link instead of crashing the site

## [1.4.0] - 2019-04-02
### Added
- Support for custom link handling classes has been added. The `handler` option for
  recordTypes can be used to swap out the default implementation.
- Add command to flush object path mappings for object types (fixes obsolete `/my-duplicate-url-1` urls)
- Shared code for topics is now located in neos-common
- A new abstract plugin node type that is used by all newland plugins has been added.

### Fixed
- Removed accidental creation of `newland_neoscommon_sitemap_sitemaphelper` database table.
- Default value for meta description is now being used if not overridden.

## [1.3.0] - 2019-03-08
### Added
- A new `documentation:eelhelper` command was added that prints the documentation
  of all available Eel helpers for usage in Fusion.
- The new abstractCommandController handles pretty progress output for long commands.

### Fixed
- Node URIs are now regenerated when being saved
