<?php declare(strict_types=1);

namespace Newland\NeosCommon\Tests\Factory;

use Neos\Flow\Mvc\Routing\ObjectPathMapping;
use Newland\Toubiz\Sync\Neos\Tests\Factory\AbstractFactory;

class ObjectPathMappingFactory extends AbstractFactory
{

    public function make(array $properties = [])
    {
        $mapping = new ObjectPathMapping();

        $mapping->setIdentifier($properties['identifier'] ?? $this->faker->uuid);
        $mapping->setPathSegment($properties['pathSegment'] ?? $this->faker->word);
        $mapping->setObjectType($properties['objectType'] ?? 'Some\Object\Type');
        $mapping->setUriPattern($properties['uriPattern'] ?? '{id}');

        return $mapping;
    }
}
