<?php
namespace Newland\NeosCommon\Eel\Helper;

/*
 * This file is part of the "neos-common" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\Node;
use Neos\Flow\Mvc\ActionRequest;
use Neos\Flow\Mvc\RequestInterface;

class NodeUtilityHelper extends ObjectPropertyHelper
{
    public function isDetailPage(Node $node, RequestInterface $request): bool
    {
        $isDetailPage = false;

        $this->node = $node;
        $this->request = $request;

        $this->getConfiguration();

        if ($this->override) {
            // If a set of plugin parameters matches a config set,
            // it's a detail page.
            $isDetailPage = $this->hasMatchingConfig();
        }

        return $isDetailPage;
    }

    public function getRecord(Node $node, RequestInterface $request)
    {
        $this->node = $node;
        $this->request = $request;

        $this->getConfiguration();

        if ($this->override) {
            $this->parseConfiguration();
            $this->setMetaDataFromScenario();
        }

        return $this->metaData;
    }

    /**
     * Parse plugin parameters and scenarios for a match
     */
    protected function hasMatchingConfig(): bool
    {
        if (!($this->request instanceof ActionRequest)) {
            return false;
        }

        foreach ($this->request->getPluginArguments() as $pluginParameters) {
            foreach ($this->scenarios as $scenario) {
                if ($this->pluginParametersMatchWithScenario($pluginParameters, $scenario)) {
                    return true;
                }
            }
        }

        return false;
    }
}
