<?php declare(strict_types=1);

namespace Newland\NeosCommon\Tests\Fusion;

use Neos\ContentRepository\Domain\Model\Node;
use Neos\Flow\Tests\FunctionalTestCase;
use Newland\NeosTestingHelpers\CompilesFusion;
use Newland\NeosTestingHelpers\InteractsWithNodes;

class MetaDescriptionTest extends FunctionalTestCase
{
    protected static $testablePersistenceEnabled = true;
    use InteractsWithNodes, CompilesFusion;

    /** @var Node */
    protected $node;

    public function setUp(): void
    {
        parent::setUp();
        $this->node = $this->initializeNode(
            '/sites/foo-bar',
            null,
            $this->initializeSite('foo-bar', 'site title'),
            [ 'metaDescription' => 'do SEO they said, it\'ll be easy they said' ]
        );
    }

    public function testGeneratesTitleTag(): void
    {
        $result = $this->compileFusion($this->node, 'Newland.NeosCommon:MetaDescription');
        $this->assertContains('<meta name="description"', $result);
    }

    public function testUsesNodePropertyByDefault(): void
    {
        $result = $this->compileFusion($this->node, 'Newland.NeosCommon:MetaDescription');
        $this->assertContains('do SEO they said, it\'ll be easy they said', $result);
    }

    public function testDoesNotOutputAnythingIfNoDescriptionSet(): void
    {
        $this->node->setProperty('metaDescription', '');
        $this->persistNode($this->node);
        $result = $this->compileFusion($this->node, 'Newland.NeosCommon:MetaDescription');
        $this->assertNull($result);
    }

    public function testDoesNotFailIfMetaDescriptionPropertyNotAvailable(): void
    {
        $this->node->setProperty('metaDescription', null);
        $this->persistNode($this->node);
        $result = $this->compileFusion($this->node, 'Newland.NeosCommon:MetaDescription');
        $this->assertNull($result);
    }
}
