<?php
namespace Newland\NeosCommon\ViewHelpers;

/*
 * This file is part of the "neos-common" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\Node;
use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use Newland\NeosCommon\Eel\Helper\NodeUtilityHelper;
use Neos\Flow\Annotations as Flow;

class NodeTitleViewHelper extends AbstractViewHelper
{
    /**
     * @var NodeUtilityHelper
     * @Flow\Inject
     */
    protected $nodeUtility;

    public function render(Node $node)
    {
        return $this->nodeUtility->getRecord($node, $this->controllerContext->getRequest())->getTitle();
    }
}
