<?php
namespace Newland\NeosCommon\Service;

/*
 * This file is part of the "neos-common" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Neos\Flow\Mvc\Routing\ObjectPathMappingRepository;
use Neos\Flow\Persistence\PersistenceManagerInterface;

class ObjectPathMappingService
{
    /**
     * @var ObjectPathMappingRepository
     * @Flow\Inject
     */
    protected $objectPathMappingRepository;

    /**
     * @var PersistenceManagerInterface
     * @Flow\Inject()
     */
    protected $persistenceManager;

    /**
     * Flush all records from the object path mapping table for a certain object type.
     *
     * @param string $objectType
     */
    public function flushMappings(string $objectType)
    {
        $objectType = trim($objectType, '\\');

        $records = $this->objectPathMappingRepository->findByObjectType($objectType);

        foreach ($records as $record) {
            $this->objectPathMappingRepository->remove($record);
        }

        $this->persistenceManager->persistAll();
    }
}
