<?php
namespace Newland\NeosCommon\Eel\Helper;

/*
 * This file is part of the "neos-common" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */


use Neos\ContentRepository\Domain\Model\Node;
use Neos\Flow\Mvc\ActionRequest;

class PageTitleHelper extends ObjectPropertyHelper
{
    /**
     * @var string
     */
    protected $websiteTitle = '';

    /**
     * Override the title of the current page
     *
     * @param Node $node
     * @param ActionRequest $request
     * @param string $defaultValue
     * @param bool $appendWebsiteTitle
     * @return string
     */
    public function getTitle(Node $node, ActionRequest $request, $defaultValue = '', $appendWebsiteTitle = true): string
    {
        $this->node = $node;
        $this->request = $request;
        $this->value = $defaultValue;

        $this->getConfiguration();

        if ($this->override) {
            $this->setValueFromRequestedRecord();
        }

        $title = $this->metaData->getTitle() ?: $defaultValue;

        if ($appendWebsiteTitle) {
            $title .= ' | ' . $this->getWebsiteTitle();
        }

        return $title;
    }

    /**
     * Get the title of the current site
     *
     * @return string
     */
    private function getWebsiteTitle(): string
    {
        return $this->node->getContext()->getCurrentSite()->getName();
    }
}
