<?php
namespace Newland\Maileon\Neos\DataSource;

/*
 * This file is part of the "maileon-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Annotations as Flow;
use Neos\Neos\Service\DataSource\AbstractDataSource;
use Newland\Maileon\Neos\Service\ApiService;

/**
 * Target groups data source.
 *
 * @Flow\Scope("singleton")
 */
class TargetGroupsDataSource extends AbstractDataSource
{
    /**
     * @var string Data source identifier.
     */
    static protected $identifier = 'maileon-neos-targetgroups';

    /**
     * @var ApiService
     * @Flow\Inject
     */
    protected $apiService;

    /**
     * Get requested data from source.
     *
     * The return value must be JSON serializable data structure.
     *
     * @api
     * @param NodeInterface $node The node that is currently edited (optional)
     * @param array $arguments Additional arguments (key / value)
     * @return mixed JSON serializable data
     */
    public function getData(NodeInterface $node = null, array $arguments = [])
    {
        $groups = [];
        $data = $this->apiService->getTargetGroups();
        foreach ($data as $group) {
            $groups[] = [
                'label' => $group['name'],
                'value' => $group['id']
            ];
        }

        return $groups;
    }
}
