<?php
namespace Newland\Maileon\Neos\DataSource;

/*
 * This file is part of the "maileon-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Annotations as Flow;
use Neos\Flow\I18n\Translator;
use Neos\Neos\Service\DataSource\AbstractDataSource;
use Newland\Maileon\Neos\Service\ApiService;

/**
 * Field mapping data source.
 *
 * @Flow\Scope("singleton")
 */
class FieldMappingDataSource extends AbstractDataSource
{
    /**
     * @var string Data source identifier.
     */
    static protected $identifier = 'maileon-neos-fieldmapping';

    /**
     * @var Translator
     * @Flow\Inject
     */
    protected $translator;

    /**
     * @var ApiService
     * @Flow\Inject
     */
    protected $apiService;

    /**
     * Get requested data from source.
     *
     * The return value must be JSON serializable data structure.
     *
     * @api
     * @param NodeInterface $node The node that is currently edited (optional)
     * @param array $arguments Additional arguments (key / value)
     * @return mixed JSON serializable data
     */
    public function getData(NodeInterface $node = null, array $arguments = [])
    {
        $fields = [
            [
                'label' => $this->translate('standardField.salutation'),
                'value' => 'standard_fields.SALUTATION',
                'group' => $this->translate('fieldGroup.standard')
            ],
            [
                'label' => $this->translate('standardField.firstName'),
                'value' => 'standard_fields.FIRSTNAME',
                'group' => $this->translate('fieldGroup.standard')
            ],
            [
                'label' => $this->translate('standardField.lastName'),
                'value' => 'standard_fields.LASTNAME',
                'group' => $this->translate('fieldGroup.standard')
            ],
            [
                'label' => $this->translate('standardField.email'),
                'value' => 'standard_fields.EMAIL',
                'group' => $this->translate('fieldGroup.standard')
            ]
        ];

        $data = $this->apiService->getCustomFields();
        foreach ($data as $field) {
            $fields[] = [
                'label' => $field,
                'value' => 'custom_fields.' . $field,
                'group' => $this->translate('fieldGroup.custom')
            ];
        }

        return $fields;
    }

    /**
     * @param string $id
     * @return string|null
     */
    private function translate(string $id)
    {
        return $this->translator->translateById(
            $id,
            [],
            null,
            null,
            'Shared',
            'Newland.Maileon.Neos'
        );
    }
}
