# XQueue Maileon package for Neos CMS.
This package provides functionality for sending form builder data to XQueue Maileon.


## Integration
Add the package to your project's `composer.json` and, to ensure proper loading order of configurations, also to your site package's `composer.json`.

Configure the API key in `Settings.yaml` (either in the site package or the global configuration);
```
Newland:
  Maileon:
    Neos:
      apiKey: 'your-api-key-here'
```


## Usage

### Form fields
When creating a form through the form builder, configure the fields that represent data that should be sent to Maileon by selecting the proper value from the "Maileon" dropdown that appears on form input nodes. This property provides both standard fields and custom fields that are configured in Maileon.

### Form finisher
Add a "Maileon" finisher to the form which is responsible for collecting the form field data and sending it to the Maileon API.

For the finisher, you have two options regarding the "submission filter":
1. **Always**: Form data is always being sent to Maileon.
2. **On active submission field**: Form data is only sent to maileon if a checkbox has the property "Submit to Maileon if active" set. This allows to build forms with a checkbox "Subscribe to our newsletter". If you use multiple submission fields, at least one has to be checked in order to submit data to maileon.


## Development

### Signals
The following signals are emitted:

| Class | Signal | Description |
|-|-|-|
| `Newland\Maileon\Neos\Finisher\MaileonFinisher` | `afterFieldsProcessed` | After form fields have been processed into a format suitable for maileon. |
