<?php declare(strict_types=1);

/*
 * Copyright (c) 2022, land in sicht AG
 *
 * www.land-in-sicht.de - All rights reserved.
 *
 * This is proprietary software. Unauthorized copying
 * of this file, via any medium, is strictly prohibited.
 */

namespace Newland\GpsFileParsing\Tests\Parser;

use Newland\GpsFileParsing\Exception\Exception;
use Newland\GpsFileParsing\Helper\XmlFileReader;
use Newland\GpsFileParsing\Parser\KmlParser;
use PHPUnit\Framework\TestCase;
use function count;

class KmlParserTest extends TestCase
{
    /** @var KmlParser */
    protected $subject;

    public function setUp(): void
    {
        parent::setUp();
        $this->subject = new KmlParser(new XmlFileReader());
    }

    /** @dataProvider provideKmlFiles */
    public function testShouldBeAbleToLoadPointFromKmlFile(string $file): void
    {
        $track = $this->subject->extractTrack($file);
        self::assertIsArray($track->getPoints());
        self::assertGreaterThan(0, count($track->getPoints()), 'Should have extracted more than one point');
    }

    public function testDoesNotFailWhenTryingToParseInvalidFile(): void
    {
        $this->expectException(Exception::class);
        $this->subject->extractTrack(__DIR__ . '/../../fixtures/invalid-files/not-xml.txt');
    }

    public function provideKmlFiles(): array
    {
        $dir = __DIR__ . '/../../fixtures/';
        $data = [];
        foreach (glob($dir . '*.kml') as $file) {
            $name = str_replace([ $dir, '.kml' ], '', $file);
            $data[$name] = [ $file ];
        }
        return $data;
    }
}
