<?php declare(strict_types=1);

/*
 * Copyright (c) 2022, land in sicht AG
 *
 * www.land-in-sicht.de - All rights reserved.
 *
 * This is proprietary software. Unauthorized copying
 * of this file, via any medium, is strictly prohibited.
 */

namespace Newland\GpsFileParsing\Tests\Parser;

use Newland\GpsFileParsing\Exception\Exception;
use Newland\GpsFileParsing\Helper\XmlFileReader;
use Newland\GpsFileParsing\Parser\GpxParser;
use PHPUnit\Framework\TestCase;
use function count;

class GpxParserTest extends TestCase
{
    /** @var GpxParser */
    protected $subject;

    public function setUp(): void
    {
        parent::setUp();
        $this->subject = new GpxParser(new XmlFileReader());
    }

    /** @dataProvider provideGpxFiles */
    public function testShouldBeAbleToLoadPointFromGpxFile(string $file): void
    {
        $track = $this->subject->extractTrack($file);
        self::assertIsArray($track->getPoints());
        self::assertGreaterThan(0, count($track->getPoints()), 'Should have extracted more than one point');
    }

    public function testDoesNotFailWhenTryingToParseInvalidFile(): void
    {
        $this->expectException(Exception::class);
        $this->subject->extractTrack(__DIR__ . '/../../fixtures/invalid-files/not-xml.txt');
    }

    public function provideGpxFiles(): array
    {
        $dir = __DIR__ . '/../../fixtures/';
        $data = [];
        foreach (glob($dir . '*.gpx') as $file) {
            $name = str_replace([ $dir, '.gpx' ], '', $file);
            $data[$name] = [ $file ];
        }
        return $data;
    }
}
