<?php declare(strict_types=1);

/*
 * Copyright (c) 2022, land in sicht AG
 *
 * www.land-in-sicht.de - All rights reserved.
 *
 * This is proprietary software. Unauthorized copying
 * of this file, via any medium, is strictly prohibited.
 */

namespace Newland\GpsFileParsing\Helper;

use Newland\GpsFileParsing\Exception\Exception as GpsFileParsingException;
use Safe\Exceptions\SafeExceptionInterface;
use function Safe\file_get_contents;
use function Safe\json_decode;
use function Safe\json_encode;
use function Safe\simplexml_load_string;

class XmlFileReader
{
    public function read(string $file): array
    {
        try {
            $fileContents = file_get_contents($file);
            $xml = simplexml_load_string($fileContents);
            $json = json_encode($xml);
            return json_decode($json, true);
        } catch (SafeExceptionInterface $exception) {
            throw new GpsFileParsingException(
                sprintf('Error reading file %s as XML: %s', $file, $exception->getMessage()),
                $exception->getCode(),
                $exception
            );
        }
    }

    public function readAsText(string $file): string
    {
        try {
            $fileContents = file_get_contents($file);
            return (string) $fileContents;
        } catch (SafeExceptionInterface $exception) {
            throw new GpsFileParsingException(
                sprintf('Error reading file %s as TEXT: %s', $file, $exception->getMessage()),
                $exception->getCode(),
                $exception
            );
        }
    }
}
