<?php declare(strict_types=1);

namespace Newland\GpsFileParsing\Parser;

use Newland\GpsFileParsing\Helper\XmlFileReader;
use Newland\GpsFileParsing\Model\Point;
use Newland\GpsFileParsing\Model\Track;

class KmlParser implements Parser
{
    /** @var XmlFileReader */
    private $reader;

    public function __construct(XmlFileReader $reader)
    {
        $this->reader = $reader;
    }

    /**
     * TODO: Handle multiple track segments
     */
    public function extractTrack(string $file): Track
    {

        $track = new Track();
        // Convert the file data to an array
        $array = $this->reader->read($file);

        // Find the placemark tag, which contains track coordinates
        $placemark = $this->recursiveTreeSearch($array['Document']);

        foreach ($placemark as $place) {
            // Search for tags that can be used to store a track
            if (isset($place['MultiGeometry'])) {
                $points = explode(' ', (string) $place['MultiGeometry']['LineString']['coordinates']);
                $points = explode("\n", $points[0]);
            } elseif (isset($place['coordinates'])) {
                $points = explode(' ', (string) $place['coordinates']);
            } elseif (isset($place['LineString'])) {
                $points = explode(' ', (string) $place['LineString']['coordinates']);
                $points = explode("\n", $points[0]);
            } elseif (isset($place['Point']['coordinates'])) {
                $points = [ $place['Point']['coordinates'] ];
            }

            // IF we have points, proceed to extract their information
            if (isset($points)) {
                foreach ($points as $point) {
                    $tmp = explode(',', $point);
                    $point = new Point((float) $tmp[1], (float) $tmp[0], (float) ($tmp[2] ?? 0));
                    $track->addPoint($point);
                }
            }
        }

        return $track;
    }

    public function recursiveTreeSearch($tree)
    {
        if (array_key_exists('Placemark', $tree) && !array_key_exists('Folder', $tree)) {
            return $tree['Placemark'];
        }

        if (array_key_exists('Folder', $tree)) {
            return $this->recursiveTreeSearch($tree['Folder']);
        }

        if (array_key_exists(0, $tree)) {
            return $this->recursiveTreeSearch($tree[0]);
        }

        return null;
    }
}
