<?php declare(strict_types=1);

namespace Newland\GpsFileParsing;

use Newland\GpsFileParsing\Exception\ParserNotFoundException;
use Newland\GpsFileParsing\Helper\XmlFileReader;
use Newland\GpsFileParsing\Parser\GpxParser;
use Newland\GpsFileParsing\Parser\KmlParser;
use Newland\GpsFileParsing\Parser\Parser;

class ParserFactory
{
    /** @var XmlFileReader */
    private $reader;

    public function __construct(XmlFileReader $reader)
    {
        $this->reader = $reader;
    }

    public function resolveParser(string $file): Parser
    {
        $extension = pathinfo($file, PATHINFO_EXTENSION);

        switch ($extension) {
            case 'kml':
                return new KmlParser($this->reader);
            case 'gpx':
                return new GpxParser($this->reader);
            default:
                throw new ParserNotFoundException(
                    sprintf(
                        'No parser for GPS track of type %s could be resolved',
                        $extension
                    )
                );
        }
    }
}
