<?php declare(strict_types=1);

namespace Newland\GpsFileParsing\Parser;

use Geometry as GeoPhpGeometry;
use GeometryCollection;
use Newland\GpsFileParsing\Exception\Exception;
use Newland\GpsFileParsing\Helper\XmlFileReader;
use Newland\GpsFileParsing\Model\Point;
use Newland\GpsFileParsing\Model\Track;

class FileBasedParser implements Parser
{
    /** @var XmlFileReader */
    private $reader;

    public function __construct(XmlFileReader $reader)
    {
        $this->reader = $reader;
    }

    public function extractTrack(string $file): Track
    {
        $geometries = $this->extractGeometries($file);

        $points = $geometries->getPoints();

        $track = new Track();
        if (isset($points)) {
            foreach ($points as $point) {
                $point = new Point((float) $point->getY(), (float) $point->getX(), (float) ($point->z() ?? 0));
                $track->addPoint($point);
            }
        }

        return $track;
    }

    /**
     * @return GeoPhpGeometry|GeometryCollection
     */
    public function extractGeometries(string $file): GeoPhpGeometry
    {
        $fileContents = $this->reader->readAsText($file);

        $geometries = \geoPHP::load($fileContents);
        if (!($geometries instanceof GeoPhpGeometry)) {
            throw new Exception('Could not parse GPS File ' . $file);
        }

        return $geometries;
    }
}
